import json
from tqdm import tqdm

old2new_foldername = {'Walk_East':'Walk_East',
                  'Driving_In_Japan_JDM':'Driving_In_Japan_JDM',
                  'Gezeyenti':'Gezeyenti',
                  'Memery_Works':'Memery_Works',
                  'J_Utah':'J_Utah',
                  'MC75':'MC75',
                  'Wind_Walk_Travel_Videos_?':'Wind_Walk_Travel_Videos_',
                  'FavesStreaming':'FavesStreaming',
                  'Planet_Drive':'Planet_Drive',
                  'Sunset_Drive_California':'Sunset_Drive_California',
                  'Driving_in_China':'Driving_in_China',
                  'guruguru':'guruguru',
                  'takemytripdotcom':'takemytripdotcom',
                  'Love,_Drive,_Travel_Drive_with_me_in_Korea':'Love_Drive_Travel_in_Korea',
                  'Relaqs_Relaxation':'Relaqs_Relaxation',
                  'The_Driving_Channel':'The_Driving_Channel',
                  'omw':'omw',
                  'Drive_&_Walk_Drive_with_me_in_Seoul,_Korea':'Drive_Walk_Seoul_Korea',
                  'USA_Thrill':'USA_Thrill',
                  'In_Motion_Travel_Tours':'In_Motion_Travel_Tours',
                  'Relaxing_Walks':'Relaxing_Walks',
                  'The_Traveler_:_Relaxing_Videos':'The_Traveler__Relaxing_Videos',
                  'Wheels_Around_The_World':'Wheels_Around_The_World',
                  'Relaxing_Scenes_-_Driving':'Relaxing_Scenes_-_Driving',
                  'THE_TABLE':'THE_TABLE',
                  '4K_DRIVE':'4K_DRIVE',
                  'tombo_walking':'tombo_walking',
                  'Easy_Travel':'Easy_Travel',
                  'World_Driving_Tours':'World_Driving_Tours',
                  'NYC_Taxi_Driver':'NYC_Taxi_Driver',
                  'Memery_World_中国记忆':'Memery_World_',
                  'GoingGoing':'GoingGoing',
                  'Slipstream_Motion_Pictures_Ltd._(Video_Tours)':'Slipstream_Motion_Pictures_Ltd',
                  '中国街景_Chinese_Street_View':'_Chinese_Street_View',
                  '4k_DRIVE_TOUR':'4k_DRIVE_TOUR',
                  'Road_Therapy':'Road_Therapy',
                  'Zhejiang_Street_Scenes':'Zhejiang_Street_Scenes',
                  'Sunday_Driver':'Sunday_Driver',
                  'Earth_Explorer':'Earth_Explorer'}

#-------------Opendv-----------------
import os
if '__main__' == __name__:
    new_loaded_json_data = []
    json_path = 'dataset/opendv/opendv_full_train.json'
    json_path = 'dataset/opendv/opendv_full_train_new_folder_name.json'
    folder_root = set()
    with open(json_path, 'r', encoding='utf-8') as f:
        json_data = json.load(f)
    print(len(json_data))
    sample_data = []
    for i in tqdm(json_data):
        main_folder, sub_folder, sub_sub_folder = i['folder'].split('/')
        sub_folder_new = os.path.join(main_folder, old2new_foldername[sub_folder], sub_sub_folder)
        sample_data = i.copy()
        sample_data['folder'] = sub_folder_new
        folder_root.add(sub_folder)
        new_loaded_json_data.append(sample_data)

    print(len(folder_root))
    new_json_path = 'dataset/opendv/opendv_full_train_new_folder_name.json'
    with open(new_json_path, 'w', encoding='utf-8') as f:
        json.dump(new_loaded_json_data, f, ensure_ascii=False)
   



